<?php
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

/* Note - this code applies the same id to many elements, which is invalid HTML and may cause unexpected behavior for js/css. 
If we're ever refactoring this code, we should consider changing the id="sender", id="subject", id="priority", etc. for table columns
to classes instead.  Additionally, it would be easier to work with this code if it was embedded PHP in HTML instetad of echoed strings,
so that we'd have the benefit of syntax highlighting/code formatting. - MG 2014-05-05 */

$mailbox_location_display_name = get_instance()->session->mailbox_location_display_name();

$optional_vars = array( 'show_workflow' => '',
						'sort_column' => '',
						);

//make sure that optional vars all have a value
foreach( $optional_vars as $optional_var => $default_value){
	if(!isset($$optional_var)) $$optional_var = $default_value;
}




// EXPECTED VARS -- headers
                    echo '<table id="messages" style="border-spacing: 1px;"' .
						 ' summary="This table lists messages in the ' . $mailbox_location_display_name .  ' folder.' .
						 ' Each row contains a checkbox for selecting an individual message to perform an action, such as Archive, Move, or Mark as Read.' .
						 ' Each table cell after the checkbox contains information about the message: The sender of the message, the subject (and the priority if applicable), the date it was sent, and the message size.">';
					echo '<caption class="hidden_context">List of messages in mailbox folder: ' . $mailbox_location_display_name . '</caption>';
					echo '<!--[if lte IE 8 ]>';
						echo '<colgroup span="7">';
							echo '<col style="width: 20px;">';
							if($show_workflow){
								echo '<col style="width: 20px;">';
							}
							echo '<col style="width: 20px;">';
							echo '<col style="width: 100px;">';
							echo '<col style="width: 390px;">';
							echo '<col style="width: 20px;">';
							echo '<col style="width: 60px;">';
							echo '<col style="width: 80px;">';
							echo '<col style="width: 70px;">';
						echo '</colgroup>';
					echo '<![endif]-->';
                    echo '<tr class="header">';
						echo '<th scope="col" class="select">';
							echo '<label for="selectall" style="display: none;">Select All</label>';
							echo '<input type="checkbox" name="selectall" id="selectall" onclick="selectAll()" />';
						echo '</th>';
						echo '<th scope="col" width="20px;" class="attachment"><img src="/images/paperclip.png" style="height: 15px;" alt="Has Attachment" title="Attachment" /></th>';
						if($show_workflow){
							echo ($sort_column === 'workflow') ? '<th scope="col" class="status_icon"><a href="/inbox/sort/workflow"><img id="legend" src="/images/dark_man.png" style="width:12.5px;" alt="Status" title="Status" />'.$sort_icon.'</a></th>' : '<th scope="col" class="status_icon"><a href="/inbox/sort/workflow"><img id="legend" src="/images/dark_man.png" style="width:12.5px;" alt="Status" title="Status" /></a></th>';
						}
						echo ($sort_column === 'sender') ? '<th scope="col" class="sender"><a href="/inbox/sort/sender/">From'.$sort_icon.'</a></th>' : '<th scope="col" class="sender"><a href="/inbox/sort/sender/">From</a></th>';
						echo ($sort_column === 'subject') ? '<th scope="col" class="subject"><a href="/inbox/sort/subject/">Subject'.$sort_icon.'</a></th>' : '<th scope="col" class="subject"><a href="/inbox/sort/subject/">Subject</a></th>';
						echo ($sort_column === 'flag') ? '<th scope="col" class="flag"><a href="/inbox/sort/flag/"><img src="/images/icons/flag_less_transparent.png" alt="Flag" title="Flag"/>'.$sort_icon.'</a></th>': '<th scope="col" class="flag"><a href="/inbox/sort/flag/"><img src="/images/icons/flag_less_transparent.png" alt="Flag" title="Flag"/></a></th>';
						echo ($sort_column === 'priority') ? '<th scope="col" class="priority"><a href="/inbox/sort/priority/">Priority'.$sort_icon.'</a></th>': '<th scope="col" class="priority"><a href="/inbox/sort/priority/">Priority</a></th>';
						echo ($sort_column === 'timestamp') ? '<th scope="col" class="date"><a href="/inbox/sort/timestamp/">Date'.$sort_icon.'</a></th>' : '<th scope="col" class="date"><a href="/inbox/sort/timestamp/">Date</a></th>';
						echo ($sort_column === 'size') ? '<th scope="col" class="size"><a href="/inbox/sort/size/">Size'.$sort_icon.'</a></th>' : '<th scope="col" class="size"><a href="/inbox/sort/size/">Size</a></th>';
					echo '</tr>';
                    foreach($headers as $msg_uid => $header) {
                        //make message bold if the message is new
						$class = '';
                        if(!$header->seen) $class = 'class="newmsg"';

                        echo '<tr>';
							echo '<td class="select">';
								echo '<label for="select' . $header->id . '" style="display: none;">Select Message with Subject: ' . $header->subject_for_display . '</label>';
								echo '<input class="selectmsg" type="checkbox" name="select' . $header->id . '" id="select' . $header->id . '" onclick="selectMsg(this)" />';
							echo '</td>';
							echo '<td style="text-align: center;">';
							if($header->has_attachments()):
								echo '<a style="position: relative; left: -3px;" '. $class . ' href="' . base_url() . 'inbox/viewmsg' . '/' . $header->id . '/">';
								echo '<img src="/images/paperclip.png" style="height: 15px;" alt="Attachment Icon" />';
								echo '</a>';
							endif;
							echo '</td>';
							if($show_workflow){
							echo'<td class="status_icon">';
								if(!isset($header->workflow_item['id'])) {
									echo '<a db_id="" href="#" class="message_status" status="unassigned" id="status_'.$header->id.'"><img src="/images/gray_man.png"  alt="Unassigned" title="Unassigned" /></a>';
								}
								else if(is_null($header->workflow_item['assigned_to'])) {
									echo '<a db_id="'.$header->workflow_item['id'].'" href="#" class="message_status" status="unassigned" id="status_'.$header->id.'"><img src="/images/gray_man.png"  alt="Unassigned" title="Unassigned" /></a>';
								}
								else if($header->workflow_item['assigned_to'] === $current_user && !$header->workflow_item['complete']) {
									echo '<a db_id="'.$header->workflow_item['id'].'" href="#" class="message_status" status="assigned_me"  id="status_'.$header->id.'"><img src="/images/blue_man.png"  alt="Assigned to '.$display_name.'" title="Assigned to '.$display_name.'" /></a>';
								}
								else if($header->workflow_item['assigned_to'] !== $current_user && !$header->workflow_item['complete']) {
									$owner = $this->user_model->user_cn_from_id($header->workflow_item['assigned_to']);
									echo '<a db_id="'.$header->workflow_item['id'].'" href="#" class="message_status" status="assigned_other"  id="status_'.$header->id.'"><img src="/images/orange_man.png"  alt="Assigned to '.$owner.'" title="Assigned to '.$owner.'" /></a>';
								}
								else if($header->workflow_item['assigned_to'] !== $current_user && $header->workflow_item['complete']) {
									$owner = $this->user_model->user_cn_from_id($header->workflow_item['assigned_to']);
									echo '<a db_id="'.$header->workflow_item['id'].'" href="#" class="message_status" status="complete_other"  id="status_'.$header->id.'"><img src="/images/complete_man.png"  alt="Completed by '.$owner.'" title="Completed by '.$owner.'" /></a>';
								}
								else {
									$owner = $this->user_model->user_cn_from_id($header->workflow_item['assigned_to']);
									echo '<a db_id="'.$header->workflow_item['id'].'" href="#" class="message_status" status="complete"  id="status_'.$header->id.'"><img src="/images/complete_man.png"  alt="Completed by '.$owner.'" title="Completed by '.$owner.'" /></a>';
								}
								echo '</td>';
							}
							
							echo '<td>';
								echo '<div class="sender">';
									echo '<a '. $class . ' id="sender" title="'.$header->sender_for_display.'" href="' . base_url() . 'inbox/viewmsg' . '/' . $header->id . '/">' . $header->sender_for_display . '</a>';
								echo '</div>';
							echo '</td>';
							echo '<td>';
								echo '<div class="subject">';
									echo '<a '. $class . ' id="subject" title="'.$header->subject_for_display.'" href="' . base_url() . 'inbox/viewmsg' . '/' . $header->id . '/">';
										if($header->has_reply_all()){
											echo '<img src="/images/replyall.png" height="20px" id="image_subject" alt="Replied All" title="Replied All" />';
										}elseif($header->has_reply()){
											echo '<img src="/images/reply.png" height="20px" id="image_subject" alt="Replied" title="Replied" />';
										}elseif($header->has_forward()){
											echo '<img src="/images/forward.png" height="20px" id="image_subject" alt="Forwarded" title="Forwarded" />';
										}
										echo $header->subject_for_display; 
									echo '</a>';
								echo '</div>';
							echo '</td>';
							echo '<td>' . $this->load->view('inbox/_flag', compact('header', 'msg_uid'), TRUE) . '</td>';
							echo '<td><a '. $class . ' id="priority" style="text-align:center;" href="' . base_url() . 'inbox/viewmsg' . '/' . $header->id . '/">';
							if($header->importance == 'high'){
								echo '<span title="High Priority" class="high_priority">!</span>';
							}elseif($header->importance == 'low'){
								echo '<span title="Low Priority" class="low_priority">&#8595;</span>';
							}
							else{
								echo '<span title="Normal Priority" class="normal_priority">&nbsp;</span>';
							}
							echo '</a></td>';
							echo '<td class="date">';
								echo '<a '. $class . ' href="' . base_url() . 'inbox/viewmsg' . '/' . $header->id . '/">' . $header->timestamp_for_display() . '</a>';
							echo '</td>';
							echo '<td>';
								echo '<a '. $class . ' href="' . base_url() . 'inbox/viewmsg' . '/' . $header->id . '/">' . $header->size_for_display() . '</a>';
							echo '</td>';
						echo '</tr>';

                    }
                    echo "</table>";
					?>
					<input style="display:none;" id="current_user" value="<?PHP echo $current_user;?>"/>
					<input style="display:none;" id="display_name" value="<?PHP echo $display_name;?>"/>
